/****** Object:  StoredProcedure [dbo].[P_EST_PROD_PRECO_ALTERACAO]    Script Date: 04/02/2014 12:39:26 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_PRECO_ALTERACAO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_PRECO_ALTERACAO]
GO
GO

/*
=======================================================================================
'Função..............: Atualizar preço do produto 
'Objetivo............: Busca os produtos que tiveram o preço alterado para aplicação do novo preço
'Tabelas.............: EST_PROD_PRECO   
'Dt Modificação......: 14/10/2020
'Modificação.........: Tag #A001 - Ao atualizar os precos de kit deve multiplicar o valor do produto pela quantidade de itens que forma o KIT.
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 

*/
 
CREATE PROCEDURE [dbo].[P_EST_PROD_PRECO_ALTERACAO] WITH ENCRYPTION AS  
BEGIN TRY
begin
	SET NOCOUNT ON;
	print 'P_EST_PROD_PRECO_ALTERACAO'
	Print 'Inicio da rotina de analise de metas de margem para bloqueio ou liberacao - Time ' + convert(varchar, getdate(),108);
	EXEC P_EST_PROD_PRECO_ANALISE_MARGEM_META
	
	Print 'Inicio aplicacao de precos produtos liberados  - Time ' + convert(varchar, getdate(),108);
	CREATE TABLE #RSPRECO (CD_ALT_PRECO  INT,
						   CD_EMP        INT,
						   CD_PROD       INT,
						   CD_FILIAL     INT,
						   VLR_TABELA    MONEY,
						   VLR_OFERTA	 MONEY,
						   CD_USU		 INT,
						   VLR_CUSTO	 MONEY,
						   TP_ALT_PRECO	 INT,
						   PERC_MARGEM   MONEY)
    DECLARE @DT_REF DATE
    SET @DT_REF=GETDATE()
	DECLARE @STS_ALT_PRECO INT
	SET @STS_ALT_PRECO=1

	INSERT INTO #RSPRECO
	SELECT  
		EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO,
		EST_PROD_PRECO_ALT_CPL.CD_EMP,
		EST_PROD_PRECO_ALT_CPL.CD_PROD, 
		EST_PROD_PRECO_ALT_PRC_FILIAL.CD_FILIAL,
		EST_PROD_PRECO_ALT_CPL.VLR_TABELA,
		EST_PROD_PRECO_ALT_CPL.VLR_OFERTA,
		EST_PROD_PRECO_ALT_CPL_LIB.CD_USU,
		COALESCE(EST_PROD_PRECO_ALT_CPL.VLR_CUSTO, 0),
		EST_PROD_PRECO_ALT.TP_ALT_PRECO,
	    ISNULL(EST_PROD_PRECO_ALT_CPL.PERC_MARGEM,0)
	FROM            
		EST_PROD_PRECO_ALT 
		INNER JOIN EST_PROD_PRECO_ALT_CPL ON 
		EST_PROD_PRECO_ALT.CD_EMP = EST_PROD_PRECO_ALT_CPL.CD_EMP AND 
		EST_PROD_PRECO_ALT.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO 
		INNER JOIN EST_PROD_PRECO_ALT_PRC_FILIAL ON 
		EST_PROD_PRECO_ALT.CD_EMP = EST_PROD_PRECO_ALT_PRC_FILIAL.CD_EMP AND 
		EST_PROD_PRECO_ALT.CD_ALT_PRECO = EST_PROD_PRECO_ALT_PRC_FILIAL.CD_ALT_PRECO 
		INNER JOIN EST_PROD ON 
		EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD.CD_EMP AND 
		EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD.CD_PROD
		INNER JOIN EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO ON
		EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_EMP AND
		EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_ALT_PRECO AND
		EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_PENDENTE_APLICACAO_PRECO.CD_PROD
		INNER JOIN EST_PROD_PRECO_ALT_CPL_LIB ON
		EST_PROD_PRECO_ALT_CPL.CD_EMP = EST_PROD_PRECO_ALT_CPL_LIB.CD_EMP AND
		EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_LIB.CD_ALT_PRECO AND
		EST_PROD_PRECO_ALT_CPL.CD_PROD = EST_PROD_PRECO_ALT_CPL_LIB.CD_PROD
	WHERE
		EST_PROD_PRECO_ALT.APLICADO IN (0,2)
		and EST_PROD_PRECO_ALT.CD_EMP=1
		and ISNULL(EST_PROD_PRECO_ALT.DT_AGENDADA,'20000101') <=@DT_REF;

Print 'Qtde registros para atualizacao: ' + convert(varchar(max), @@ROWCOUNT);

--Se nao existir preco do produto 
IF EXISTS(select
			top 1 r.CD_PROD
		  FROM         
			#RSPRECO r 
			LEFT OUTER JOIN EST_PROD_PRECO ON 
			r.CD_EMP	= EST_PROD_PRECO.CD_EMP AND 
			r.CD_FILIAL = EST_PROD_PRECO.CD_FILIAL AND 
			r.CD_PROD	= EST_PROD_PRECO.CD_PROD
		WHERE
			EST_PROD_PRECO.CD_PROD IS NULL)
begin
INSERT INTO EST_PROD_PRECO
	(CD_EMP
      ,CD_FILIAL
      ,CD_CTR
      ,CD_PROD
      ,VLR_TABELA
      ,VLR_OFERTA
      ,DT_CAD
      ,CD_USU
      ,STS_PRECO 
      ,PERC_ICMS
      ,PERC_IMP
      ,PERC_COMIS
      ,PERC_DESP
      ,PERC_MARGEM
      ,STS_IMP_ETQ_GOND
      ,VLR_TABELA_ANT
      ,VLR_OFERTA_ANT
      ,VLR_CUSTO_GER
      ,ORIG_PRECO
      ,PRECO_ESPECIFICO
      ,VLR_OFERTA_AVISTA
	  ,CD_ALT_PRECO
	  ,DT_REGISTRO
	  ,VLR_CUSTO_INI
	  ,VLR_CUSTO)
	select
		DISTINCT
		r.CD_EMP,
		r.CD_FILIAL,
		0 AS CD_CTR,
		r.CD_PROD,
		0 AS VLR_TABELA,
		0 AS VLR_OFERTA,
		CONVERT(CHAR(10),GETDATE(),112) AS DT_CAD,
		MAX(r.CD_USU) AS CD_USU,
		0 AS STS_PRECO, 
		0 AS PERC_ICMS,
		0 AS PERC_IMP,
		0 AS PERC_COMIS,
		0 AS PERC_DESP,
		SUM(R.PERC_MARGEM),
		0 AS STS_IMP_ETQ_GOND,
		0 AS VLR_TABELA_ANT,
		0 AS VLR_OFERTA_ANT,
		0 AS VLR_CUSTO_GER,
		0 AS ORIG_PRECO,
		0 AS PRECO_ESPECIFICO,
		0 AS VLR_OFERTA_AVISTA,
		MAX(R.CD_ALT_PRECO),
		GETDATE(),
		0 AS VLR_CUSTO_INI,
		0 AS VLR_CUSTO
	FROM         
		#RSPRECO r 
		LEFT OUTER JOIN EST_PROD_PRECO ON 
		r.CD_EMP = EST_PROD_PRECO.CD_EMP AND 
		r.CD_FILIAL = EST_PROD_PRECO.CD_FILIAL AND 
		r.CD_PROD = EST_PROD_PRECO.CD_PROD

		INNER JOIN EST_PROD_CPL c ON 
		r.CD_EMP = c.CD_EMP AND 
		r.CD_FILIAL = c.CD_FILIAL AND 
		r.CD_PROD = c.CD_PROD

	WHERE
		EST_PROD_PRECO.CD_PROD IS NULL
	GROUP BY
		r.CD_EMP,
		r.CD_FILIAL,
		r.CD_PROD;

Print 'Insercao dos produtos que não constavam na tabela de preço - Time ' + convert(varchar, getdate(),108);
Print 'Qtde registros: ' + convert(varchar(max), @@ROWCOUNT);

end
/***********************************************************************************************************/
--Tag #A001 
	--Atualiza os precos de kit referenciados 
	INSERT INTO #RSPRECO 
	select 
		r.CD_ALT_PRECO,
		r.CD_EMP,
		k.CD_PROD,
		r.CD_FILIAL,
		sum(Convert(money, ((r.VLR_TABELA * k.qt_prod)* (k.PERC_VLR_VENDA/100.00)))),
		0 VLR_OFERTA,
		r.CD_USU,
		R.VLR_CUSTO,
		R.TP_ALT_PRECO ,
	    0 PERC_MARGEM
	from 
		#RSPRECO r 
		INNER JOIN EST_PROD_PRECIFICACAO_KIT_CPL k ON 
		r.CD_EMP	= k.CD_EMP AND  
		r.CD_PROD	= k.CD_PROD_IT
		and r.CD_PROD	<> k.CD_PROD
	group by 		
		r.CD_ALT_PRECO,
		r.CD_EMP,
		k.CD_PROD,
		r.CD_FILIAL,
		r.CD_USU,
		R.VLR_CUSTO,
		R.TP_ALT_PRECO ;

/***********************************************************************************************************/
	SELECT
		 CD_EMP	
		, CD_FILIAL
		, CD_PROD	
		, max (CD_ALT_PRECO) CD_ALT_PRECO
		INTO #RSMAIOR_CD_ALT_PRECO
	from 
		#RSPRECO r 
	GROUP BY CD_EMP	
		, CD_FILIAL
		, CD_PROD	


	UPDATE
		EST_PROD_PRECO
	SET
		EST_PROD_PRECO.VLR_TABELA = CASE WHEN r.TP_ALT_PRECO = 0 THEN R.VLR_TABELA ELSE  EST_PROD_PRECO.VLR_TABELA END,
		EST_PROD_PRECO.VLR_OFERTA = CASE WHEN r.TP_ALT_PRECO = 1 THEN R.VLR_OFERTA ELSE  EST_PROD_PRECO.VLR_OFERTA END,
		EST_PROD_PRECO.VLR_CUSTO = r.VLR_CUSTO,
		EST_PROD_PRECO.CD_USU = r.CD_USU,
		EST_PROD_PRECO.DT_CAD= CONVERT(CHAR(10),GETDATE(),112),
		EST_PROD_PRECO.DT_REGISTRO=GETDATE(),
		EST_PROD_PRECO.CD_ALT_PRECO=r.CD_ALT_PRECO,
		EST_PROD_PRECO.VLR_CUSTO_INI=0,
        EST_PROD_PRECO.PERC_MARGEM = CASE WHEN r.PERC_MARGEM = 0 THEN EST_PROD_PRECO.PERC_MARGEM ELSE r.PERC_MARGEM END
	FROM         
		#RSPRECO r 
		INNER JOIN EST_PROD_PRECO ON 
		r.CD_EMP	= EST_PROD_PRECO.CD_EMP AND 
		r.CD_FILIAL = EST_PROD_PRECO.CD_FILIAL AND 
		r.CD_PROD	= EST_PROD_PRECO.CD_PROD
		INNER JOIN #RSMAIOR_CD_ALT_PRECO H ON 
		r.CD_EMP	= H.CD_EMP AND 
		r.CD_FILIAL = H.CD_FILIAL AND 
		r.CD_PROD	= H.CD_PROD AND
		r.CD_ALT_PRECO	= H.CD_ALT_PRECO
		
		;

Print 'Atualizacao dos precos - Time ' + convert(varchar, getdate(),108);
Print 'Qtde registros: ' + convert(varchar(max), @@ROWCOUNT);

UPDATE
	EST_PROD_PRECO_ALT
SET
	EST_PROD_PRECO_ALT.APLICADO  = 1,
	DT_APLICACAO=GETDATE()
FROM         
	#RSPRECO r INNER JOIN EST_PROD_PRECO_ALT ON 
	r.CD_EMP = EST_PROD_PRECO_ALT.CD_EMP AND 
	r.CD_ALT_PRECO = EST_PROD_PRECO_ALT.CD_ALT_PRECO;

UPDATE
	EST_PROD_PRECO_ALT
SET
	EST_PROD_PRECO_ALT.APLICADO  = 2,
	DT_APLICACAO=GETDATE()
FROM         
	#RSPRECO r 
	INNER JOIN EST_PROD_PRECO_ALT ON 
		r.CD_EMP = EST_PROD_PRECO_ALT.CD_EMP AND 
		r.CD_ALT_PRECO = EST_PROD_PRECO_ALT.CD_ALT_PRECO
	INNER JOIN EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE ON
		r.CD_EMP = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_EMP AND
		r.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_ALT_PRECO AND
		r.CD_PROD = EST_PROD_PRECO_ALT_CPL_LIB_PENDENTE.CD_PROD;

	Print 'Atualizando status da tabela de alteracao - Time ' + convert(varchar, getdate(),108);
	Print 'Qtde registros: ' + convert(varchar(max), @@ROWCOUNT);

	DROP TABLE #RSPRECO;
end
END TRY
BEGIN CATCH
	INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
		SELECT
			ERROR_NUMBER() AS numero,
			ERROR_SEVERITY() AS severidade,
			ERROR_STATE() AS estado,
			ERROR_PROCEDURE() AS rotina,
			ERROR_LINE() AS linha,
			ERROR_MESSAGE() AS mensagem,
			GETDATE() AS dtErro;	
END CATCH	
